/*****************************************************************************
*  LPC81x SCT demoprogram for MicroCore48 rev B board
*
*  1. Use SCT timer to generate a PWM output signal @ CTOUT_0
*  2. Every time P0_6 goes high to low increase the duty cycle.
*  3. Every time P0_1 goes high to low decrease the duty cycle.
*****************************************************************************/
#include "LPC8xx.h"

extern void SCT_Init(void);

int main (void) 
{
  static uint8_t trg1 = 1;
  static uint8_t trg2 = 1;

    LPC_SWM->PINASSIGN6 = 0x07FFFFFF;                          // SCT OUTP_0 at P0.7
    SCT_Init();                                                // Initialize SCT

    while (1)                                                  // loop forever
    {
        if (!(LPC_GPIO_PORT->PIN0 & (1 << 6)) && trg1)         // P0.6 high to low?
        {
            trg1 = 0;                                          // trigger P0.6 low
            if (LPC_SCT->MATCHREL[1].L < 19)
                LPC_SCT->MATCHREL[1].L ++;                     // increase PWM dutycycle
        }
        else if ((LPC_GPIO_PORT->PIN0 & (1 << 6)) && !trg1)    // P0.6 low to high?
        {
            trg1 = 1;                                          // trigger P0.6 high
        }

        if (!(LPC_GPIO_PORT->PIN0 & (1 << 1)) && trg2)         // P0.1 high to low?
        {
            trg2 = 0;                                          // trigger P0.1 low
            if (LPC_SCT->MATCHREL[1].L > 0)
                LPC_SCT->MATCHREL[1].L --;                     // increase PWM dutycycle
        }
        else if ((LPC_GPIO_PORT->PIN0 & (1 << 1)) && !trg2)    // P0.1 low to high?
        {
            trg2 = 1;                                          // trigger P0.1 high
        }
    }
}
